/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.client.gui.Icon;
import appeng.integration.modules.jei.widgets.View;
import appeng.integration.modules.jei.widgets.Widget;
import appeng.integration.modules.jei.widgets.WidgetFactory;
import appeng.util.Platform;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;

public abstract class ViewBasedCategory<T>
implements IRecipeCategory<T> {
    private final WidgetFactory widgetFactory;
    private final LoadingCache<T, CachedView> cache;
    protected final IGuiHelper guiHelper;
    protected final IJeiHelpers jeiHelpers;

    protected ViewBasedCategory(IJeiHelpers helpers) {
        this.jeiHelpers = helpers;
        this.guiHelper = helpers.getGuiHelper();
        this.widgetFactory = new WidgetFactory(helpers);
        this.cache = CacheBuilder.newBuilder().maximumSize(10L).build(new CacheLoader<T, CachedView>(){

            public CachedView load(T recipe) {
                return new CachedView(ViewBasedCategory.this.getView(recipe));
            }
        });
    }

    protected abstract View getView(T var1);

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        ((CachedView)this.cache.getUnchecked(recipe)).view.buildSlots(builder);
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        CachedView cachedView = (CachedView)this.cache.getUnchecked(recipe);
        for (Widget widget : this.getWidgets(cachedView)) {
            widget.draw(stack);
        }
        cachedView.view.draw(stack, recipeSlotsView, mouseX, mouseY);
    }

    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        CachedView cachedView = (CachedView)this.cache.getUnchecked(recipe);
        List<Component> tooltipLines = cachedView.view.getTooltipStrings(mouseX, mouseY);
        if (!tooltipLines.isEmpty()) {
            return tooltipLines;
        }
        List<Widget> widgets = this.getWidgets(cachedView);
        for (int i = widgets.size() - 1; i >= 0; --i) {
            List<Component> lines;
            Widget widget = widgets.get(i);
            if (!widget.hitTest(mouseX, mouseY) || (lines = widget.getTooltipLines()).isEmpty()) continue;
            return lines;
        }
        return List.of();
    }

    protected final IDrawable getIconDrawable(Icon icon) {
        return this.guiHelper.drawableBuilder(Icon.TEXTURE, icon.x, icon.y, icon.width, icon.height).setTextureSize(256, 256).build();
    }

    private List<Widget> getWidgets(CachedView cachedView) {
        if (Platform.isDevelopmentEnvironment() || cachedView.widgets == null) {
            cachedView.widgets = new ArrayList<Widget>();
            cachedView.view.createWidgets(this.widgetFactory, cachedView.widgets);
        }
        return cachedView.widgets;
    }

    private static class CachedView {
        private final View view;
        public List<Widget> widgets;

        public CachedView(View view) {
            this.view = view;
        }
    }
}

